import os
import json
import requests
from datetime import datetime

# ==========================
# CONFIGURACIONES
# ==========================
CHANNELS = {
    "tnannastein": ["pickup", "delivery"],
    "magento": ["pickup", "delivery"],
    "MELI": ["pickup", "delivery"],
    "farmaciadigital": ["pickup", "delivery"],
    "farmatouch": ["pickup", "delivery"],
    "RAPPI": ["delivery"],
    "PEYA": ["delivery"],
    "benvida": ["pickup", "delivery"],
    "vtex": ["delivery"]
}

EXTERNAL_FILE = "external_number.txt"
INITIAL_EXTERNAL = 40001400
URL = "https://bmc-foco.dev.napse.global:8444/order/create"
SHIPPING_COST = 15  # Costo fijo de envío

# ==========================
# FUNCIONES
# ==========================
def get_next_external_number():
    if os.path.exists(EXTERNAL_FILE):
        with open(EXTERNAL_FILE, "r") as f:
            num = int(f.read().strip())
    else:
        num = INITIAL_EXTERNAL - 1

    next_num = num + 1
    with open(EXTERNAL_FILE, "w") as f:
        f.write(str(next_num))
    return str(next_num)

# ==========================
# INTERACCIÓN CON EL USUARIO
# ==========================
print("Seleccione un canal:")
for i, (ch, modes) in enumerate(CHANNELS.items(), 1):
    marca = " *P/D" if len(modes) == 2 else ""
    print(f"{i}. {ch}{marca}")

# seleccionar canal (sin validación exhaustiva para mantener simple)
canal_idx = int(input("Número de canal: ").strip()) - 1
channelCode = list(CHANNELS.keys())[canal_idx]
delivery_modes = CHANNELS[channelCode]

# Selección de entrega
if delivery_modes == ["delivery"]:
    deliveryOrPickup = "delivery"
    print(f"👉 Canal {channelCode} solo acepta delivery, se asigna automáticamente.")
else:
    while True:
        print("\nTipo de entrega:")
        print("1. pickup")
        print("2. delivery")
        tipo_entrega_input = input("Seleccione 1 o 2: ").strip()
        if tipo_entrega_input == "1":
            deliveryOrPickup = "pickup"
            break
        elif tipo_entrega_input == "2":
            deliveryOrPickup = "delivery"
            break
        else:
            print("❌ Opción inválida. Debe elegir 1 o 2.")

# Selección de storeCode
print("\n3. Indicar Tienda")
print("1. 100000001")
print("2. 100000002")
print("3. 100000003")
print("4. 100000002")
store_input = input("Seleccione 1 al 4: ").strip()
if store_input == "1":
    storeCode = "100000001"
elif store_input == "2":
    storeCode = "100000002"
elif store_input == "3":
    storeCode = "100000003"
elif store_input == "4":
    storeCode = "100000002"
else:
    print("❌ Opción inválida. Debe elegir entre 1 y 4.")
    exit(1)

# ¿Está pagado?
isPaid = input("¿Está pagado? (s/n): ").strip().lower() == "s"

# Pedir x-access-token obligatorio para el envío
token = input("\nIngrese el x-access-token: ").strip()

# ==========================
# ARMADO DEL PEDIDO
# ==========================
creationDate = datetime.now().strftime("%Y-%m-%d")
externalNumber = get_next_external_number()

pedido = {
    "externalNumber": externalNumber,
    "creationDate": creationDate,
    "channelCode": channelCode,
    "currencyCode": "ARS",
    "manualDiscountAmount": 0,
    "netAmount": 11000,  # base
    "orderTypeCode": "web",
    "isPaid": isPaid,
    "party": {
        "code": "",
        "firstName": "Alejandro",
        "lastName": "Isola",
        "email": "Leo@napse.global",
        "typeCode": "Person",
        "identificationType": 1,
        "identifier": "2995028",
        "partyContactMethods": [
            {
                "name": "personal",
                "address": {
                    "firstLine": "Av San Aurelio 7844",
                    "countryCode": "AR",
                    "stateCode": "BA",
                    "cityCode": "BSAS_194"
                },
                "emailAddress": "alejandro.silva@napse.global",
                "telephone": {
                    "telephoneNumber": "0342 4744900"
                },
            }
        ]
    },
    "detail": [
        {
            "itemCode": "9018",
            "description": "BETALMAX 60MG",
            "storeCode": storeCode,
            "locationCode": "DEP1",
            "unitPrice": 5000,
            "orderedQty": 2,
            "deliveryOrPickup": deliveryOrPickup,
            "deliveryCompany": "100000003",
            "pickupLocationCode": "100000003",
            "packageId": "0",
            "partyContactMethodName": "personal",
            "pickupInformation": "Info: Alejandro Silva Mirgor retira por tienda."
        },
        {
            "itemCode": "1477",
            "description": "PBRAVA DESOD. LUBRICANTE-sachet cajax20 cód.12060",
            "storeCode": storeCode,
            "locationCode": "DEP1",
            "unitPrice": 1000,
            "orderedQty": 1,
            "deliveryOrPickup": deliveryOrPickup,
            "deliveryCompany": "100000003",
            "pickupLocationCode": "100000003",
            "packageId": "0",
            "partyContactMethodName": "personal",
            "pickupInformation": "Info: Alejandro Silva Mirgor retira por tienda."
        }
    ]
}

# Agregar envío si corresponde
if deliveryOrPickup == "delivery":
    envio_item = {
        "itemCode": "ENVIO",
        "description": "Costo de Envio",
        "storeCode": "100000004",
        "locationCode": "DEP1",
        "unitPrice": SHIPPING_COST,
        "orderedQty": 1,
        "deliveryOrPickup": "delivery",
        "deliveryCompany": "magento",
        "pickupLocationCode": "100000003",
        "packageId": "0",
        "partyContactMethodName": "personal",
        "pickupInformation": "Info: Alejandro Silva retira por tienda.",
        "notes": "RECETA=true|CODIGO=999999|MATMED=88888888888888",
        "sellerID": "omni",
        "sellerName": "Usuario para WF OMNI"
    }
    pedido["detail"].append(envio_item)
    pedido["netAmount"] += SHIPPING_COST

# Payments
if isPaid:
    pago = {
        "tender": "EL",
        "amount": pedido["netAmount"],  # monto ajustado
        "currencyCode": "ARS",
        "planDescriptor": "12",
        "sellerName": "vISA CREDITO",
        "authorizationCode": "9187840193",
        "couponNumber": "123",
        "lotNumber": "4321",
        "installments": 6,
        "referenceNumber": "383409####0415"
    }
    pedido["payments"] = [pago]
else:
    pedido["payments"] = []

# ==========================
# GUARDAR Y ENVIAR
# ==========================
with open("pedido.json", "w", encoding="utf-8") as f:
    json.dump(pedido, f, indent=4, ensure_ascii=False)

print("\n✅ Pedido generado en pedido.json")
print(f"Canal: {channelCode} | isPaid: {isPaid} | deliveryOrPickup: {deliveryOrPickup} | externalNumber: {externalNumber}")

# Envío con header x-access-token
headers = {
    "Content-Type": "application/json",
    "x-access-token": token
}

try:
    response = requests.post(URL, headers=headers, json=pedido)
    print(f"\n📡 Enviado a: {URL}")
    print("Status:", response.status_code)
    print("Respuesta:", response.text)
except Exception as e:
    print("❌ Error al enviar:", str(e))

##Creado por Alejandro Silva
